/*****************************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2Engine, Inc. Copyright (C) 2011-2014 X2Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 66752, Scotts Valley,
 * California 95067, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2Engine".
 *****************************************************************************************/

drop table if exists `x2_auth_assignment`,`x2_auth_item_child`,`x2_auth_item`,`x2_auth_cache`;
/*&*/
create table `x2_auth_item`
(
   `name`                 varchar(64) not null,
   `type`                 integer not null,
   `description`          text,
   `bizrule`              text,
   `data`                 text,
   primary key (`name`)
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
create table `x2_auth_item_child`
(
   `parent`               varchar(64) not null,
   `child`                varchar(64) not null,
   primary key (`parent`,`child`),
   foreign key (`parent`) references `x2_auth_item` (`name`) on delete cascade on update cascade,
   foreign key (`child`) references `x2_auth_item` (`name`) on delete cascade on update cascade
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
create table `x2_auth_assignment`
(
   `itemname`             varchar(64) not null,
   `userid`               varchar(64) not null,
   `bizrule`              text,
   `data`                 text,
   primary key (`itemname`,`userid`),
   foreign key (`itemname`) references `x2_auth_item` (`name`) on delete cascade on update cascade
) COLLATE = utf8_general_ci, ENGINE=INNODB;
/*&*/
CREATE TABLE x2_auth_cache(
	authItem			VARCHAR(100)	NOT NULL,
	userId				INT				NOT NULL,
	expire				INT				NOT NULL,
	value				TINYINT(1),
	PRIMARY KEY (userId, authItem),
	INDEX (userId)
) COLLATE = utf8_general_ci;
/*&*/
INSERT INTO `x2_auth_item`
(`name`,`type`,`description`,`bizrule`,`data`)
VALUES
('AccountsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('AccountsAddUser',0,'',NULL,'N;'),
('AccountsAdmin',0,'',NULL,'N;'),
('AccountsAdminAccess',1,'',NULL,'N;'),
('AccountsBasicAccess',1,'',NULL,'N;'),
('AccountsCreate',0,'',NULL,'N;'),
('AccountsDelete',0,'',NULL,'N;'),
('AccountsDeleteNote',0,'',NULL,'N;'),
('AccountsDeletePrivate',1,'Delete their own records.','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('AccountsFullAccess',1,'',NULL,'N;'),
('AccountsGetItems',0,'',NULL,'N;'),
('AccountsGetX2ModelInput',0,'',NULL,'N;'),
('AccountsIndex',0,'',NULL,'N;'),
('AccountsMinimumRequirements',1,'',NULL,'N;'),
('AccountsPrivateFullAccess',1,'',NULL,'N;'),
('AccountsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('AccountsPrivateUpdateAccess',1,'',NULL,'N;'),
('AccountsReadOnlyAccess',1,'',NULL,'N;'),
('AccountsRemoveUser',0,'',NULL,'N;'),
('AccountsSearch',0,'',NULL,'N;'),
('AccountsShareAccount',0,'',NULL,'N;'),
('AccountsUpdate',0,'',NULL,'N;'),
('AccountsUpdateAccess',1,'',NULL,'N;'),
('AccountsUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('AccountsView',0,'',NULL,'N;'),
('AccountsViewPrivate',1,'View their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('AccountsAccountsReport',0,'',NULL,'N;'),
('AccountsExportAccountsReport',0,'',NULL,'N;'),
('ActionsAdmin',0,'',NULL,'N;'),
('ActionsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ActionsAdminAccess',1,'The user has administrative access to the Actions module.',NULL,'N;'),
('ActionsBasicAccess',1,'The user can create and view records.',NULL,'N;'),
('ActionsComplete',0,'',NULL,'N;'),
('ActionsCompleteSelected',0,'',NULL,'N;'),
('ActionsCreate',0,'',NULL,'N;'),
('ActionsViewAction',0,'',NULL,'N;'),
('ActionsToggleSticky',0,'',NULL,'N;'),
('ActionsDelete',0,'',NULL,'N;'),
('ActionsDeleteNote',0,'',NULL,'N;'),
('ActionsDeletePrivate',1,'Delete assigned records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ActionsFullAccess',1,'The user is able to create, read, update, and delete actions but lacks adminstrative functions.',NULL,'N;'),
('ActionsGetTerms',0,'',NULL,'N;'),
('ActionsGetX2ModelInput',0,'',NULL,'N;'),
('ActionsIndex',0,'',NULL,'N;'),
('ActionsInvalid',0,'',NULL,'N;'),
('ActionsMinimumRequirements',1,'Minimum requirements to access the actions module.',NULL,'N;'),
('ActionsParseType',0,'',NULL,'N;'),
('ActionsPrivateFullAccess',1,'The user is able to create and read all actions, and able to update and delete actions assigned to them.',NULL,'N;'),
('ActionsPrivateReadOnlyAccess',1,'The user can only view their own actions.',NULL,'N;'),
('ActionsPrivateUpdateAccess',1,'The user is able to update their own actions.',NULL,'N;'),
('ActionsPublisherCreate',0,'',NULL,'N;'),
('ActionsQuickUpdate',0,'',NULL,'N;'),
('ActionsReadOnlyAccess',1,'The user can only view records.',NULL,'N;'),
('ActionsSaveShowActions',0,'',NULL,'N;'),
('ActionsSearch',0,'',NULL,'N;'),
('ActionsSendReminder',0,'',NULL,'N;'),
('ActionsShareAction',0,'',NULL,'N;'),
('ActionsTimerControl',0,'',NULL,'N;'),
('ActionsTomorrow',0,'',NULL,'N;'),
('ActionsUncomplete',0,'',NULL,'N;'),
('ActionsUncompleteSelected',0,'',NULL,'N;'),
('ActionsUpdate',0,'',NULL,'N;'),
('ActionsUpdateAccess',1,'The user is able to create, read, and update all actions.',NULL,'N;'),
('ActionsUpdatePrivate',1,'Update assigned records.','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ActionsView',0,'',NULL,'N;'),
('ActionsViewAll',0,'',NULL,'N;'),
('ActionsViewGroup',0,'',NULL,'N;'),
('ActionsViewPrivate',1,'View assigned records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('admin',2,'Default admin user','return Yii::app()->user->name === \'admin\';','N;'),
('administrator',2,'Admin user','','N;'),
('AdminSetDefaultTheme',0,'',NULL,'N;'),
('AdminManageActionPublisherTabs',0,'',NULL,'N;'),
('AdminChangeApplicationName',0,'',NULL,'N;'),
('AdminClearChangelog',0,'Clear out the changelog.',NULL,'N;'),
('AdminAddCriteria',0,'Access the page to create criteria which will trigger notifications.',NULL,'N;'),
('AdminCreateUpdateField',0,'Create a new field, or update a field.',NULL,'N;'),
('AdminAppSettings',0,'General settings for the application.',NULL,'N;'),
('AdminManageSessions',0,'Manage user sessions.',NULL,'N;'),
('AdminToggleSession',0,'',NULL,'N;'),
('AdminEndSession',0,'',NULL,'N;'),
('AdminPrepareImport',0,'',NULL,'N;'),
('AdminGlobalImport',0,'',NULL,'N;'),
('AdminCleanUpImport',0,'',NULL,'N;'),
('AdminDownloadData',0,'',NULL,'N;'),
('AdminPrepareExport',0,'',NULL,'N;'),
('AdminGlobalExport',0,'',NULL,'N;'),
('AdminRollbackImport',0,'',NULL,'N;'),
('AdminRollbackStage',0,'',NULL,'N;'),
('AdminManageTags',0,'',NULL,'N;'),
('AdminDeleteTag',0,'',NULL,'N;'),
('AdminConvertCustomModules',0,'',NULL,'N;'),
('AdminCreateModule',0,'Create a new module.',NULL,'N;'),
('AdminCreatePage',0,'Create a static page for the top menu bar.',NULL,'N;'),
('AdminDeleteDropdown',0,'Delete a dropdown.',NULL,'N;'),
('AdminDeleteField',0,'Delete a custom field.',NULL,'N;'),
('AdminDeleteModule',0,'Delete a module or static page.',NULL,'N;'),
('AdminDeleteRole',0,'',NULL,'N;'),
('AdminDropDownEditor',0,'Create a new dropdown.',NULL,'N;'),
('AdminEditDropdown',0,'Customize a dropdown.',NULL,'N;'),
('AdminEditor',0,'Form editor control.',NULL,'N;'),
('AdminEditRole',0,'',NULL,'N;'),
('AdminEditRoleAccess',0,'',NULL,'N;'),
('AdminEmailDropboxSettings',0,'Edit the email dropbox settings.',NULL,'N;'),
('AdminEmailSetup',0,'Configure email settings for the application.',NULL,'N;'),
('AdminExport',0,'Global data export.',NULL,'N;'),
('AdminExportModule',0,'Export a module to a .zip file.',NULL,'N;'),
('AdminGoogleIntegration',0,'Permissions for integrating the application with Google.',NULL,'N;'),
('AdminImport',0,'Global data import.',NULL,'N;'),
('AdminExportModels',0,'',NULL,'N;'),
('AdminExportModelRecords',0,'',NULL,'N;'),
('AdminImportModels',0,'',NULL,'N;'),
('AdminImportModelRecords',0,'',NULL,'N;'),
('AdminPrepareModelImport',0,'',NULL,'N;'),
('AdminCleanUpModelImport',0,'',NULL,'N;'),
('AdminImportModule',0,'Import a zip file of a module.',NULL,'N;'),
('AdminIndex',0,'Access the index page of the administrator tab.',NULL,'N;'),
('AdminWorkflowSettings',0,'Control settings for editing workflow actions.',NULL,'N;'),
('AdminUpdaterSettings',0,'Control settings for the auto-updater.',NULL,'N;'),
('AdminUpdater',0,'',NULL,'N;'),
('AdminUpdateStage',0,'',NULL,'N;'),
('AdminViewLog',0,'',NULL,'N;'),
('AdminLockApp',0,'',NULL,'N;'),
('AdminManageDropDowns',0,'General dropdown management.',NULL,'N;'),
('AdminManageFields',0,'Manage created fields.',NULL,'N;'),
('AdminManageModules',0,'Manage top bar menu items.',NULL,'N;'),
('AdminManageRoles',0,'',NULL,'N;'),
('AdminPublicInfo',0,'',NULL,'N;'),
('AdminRenameModules',0,'Rename a module in the top menu bar.',NULL,'N;'),
('AdminRoleEditor',0,'',NULL,'N;'),
('AdminRoleException',0,'',NULL,'N;'),
('AdminRoundRobinRules',0,'Edit custom round robin lead distribution rules.',NULL,'N;'),
('AdminSetLeadRouting',0,'Manage lead distribution methods.',NULL,'N;'),
('AdminToggleDefaultLogo',0,'Toggle the logo in the top left corner.',NULL,'N;'),
('AdminTranslationManager',0,'Translation manager for the application',NULL,'N;'),
('AdminUploadLogo',0,'Upload your own logo for the top left corner.',NULL,'N;'),
('AdminGetNUsers',0,'',NULL,'N;'),
('AdminSaveEdition',0,'',NULL,'N;'),
('AdminViewChangelog',0,'View a list of all changes made by users.',NULL,'N;'),
('AdminViewSessionLog',0,'',NULL,'N;'),
('AdminViewSessionHistory',0,'',NULL,'N;'),
('AdminUserViewLog',0,'',NULL,'N;'),
('AdminClearViewHistory',0,'',NULL,'N;'),
('AdminCalculateMissingTranslations',0,'',NULL,'N;'),
('AdminX2CronSettings',0,'',NULL,'N;'),
('AdminBackup',0,'',NULL,'N;'),
('AdminCheckDatabaseBackup',0,'',NULL,'N;'),
('StudioImportFlow',0,'',NULL,'N;'),
('StudioExportFlow',0,'',NULL,'N;'),
('StudioAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('StudioFlowIndex',0,'',NULL,'N;'),
('StudioFlowDesigner',0,'',NULL,'N;'),
('StudioDeleteFlow',0,'',NULL,'N;'),
('StudioTest',0,'',NULL,'N;'),
('StudioGetParams',0,'',NULL,'N;'),
('StudioGetFields',0,'',NULL,'N;'),
('StudioDeleteNote',0,'',NULL,'N;'),
('StudioSearch',0,'',NULL,'N;'),
('StudioGetX2ModelInput',0,'',NULL,'N;'),
('StudioTriggerLogs',0,'',NULL,'N;'),
('StudioDeleteAllTriggerLogs',0,'',NULL,'N;'),
('StudioDeleteAllTriggerLogsForAllFlows',0,'',NULL,'N;'),
('StudioDeleteTriggerLog',0,'',NULL,'N;'),
('authenticated',2,'Authenticated user','return !Yii::app()->user->isGuest;','N;'),
('DefaultRole',2,'Default permission set','','N;'),
('AuthenticatedSiteFunctionsTask',1,'A set of permissions required to use the site while logged in.',NULL,'N;'),
('CalendarAdmin',0,'',NULL,'N;'),
('CalendarAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('CalendarAdminAccess',1,'',NULL,'N;'),
('CalendarBasicAccess',1,'',NULL,'N;'),
('CalendarCompleteAction',0,'',NULL,'N;'),
('CalendarCreate',0,'',NULL,'N;'),
('CalendarDelete',0,'',NULL,'N;'),
('CalendarDeleteAction',0,'',NULL,'N;'),
('CalendarDeleteGoogleEvent',0,'',NULL,'N;'),
('CalendarDeleteNote',0,'',NULL,'N;'),
('CalendarEditAction',0,'',NULL,'N;'),
('CalendarEditGoogleEvent',0,'',NULL,'N;'),
('CalendarFullAccess',1,'',NULL,'N;'),
('CalendarGetX2ModelInput',0,'',NULL,'N;'),
('CalendarIndex',0,'',NULL,'N;'),
('CalendarJsonFeed',0,'',NULL,'N;'),
('CalendarJsonFeedGoogle',0,'',NULL,'N;'),
('CalendarJsonFeedGroup',0,'',NULL,'N;'),
('CalendarJsonFeedShared',0,'',NULL,'N;'),
('CalendarMinimumRequirements',1,'',NULL,'N;'),
('CalendarMoveAction',0,'',NULL,'N;'),
('CalendarMoveGoogleEvent',0,'',NULL,'N;'),
('CalendarMyCalendarPermissions',0,'',NULL,'N;'),
('CalendarReadOnlyAccess',1,'',NULL,'N;'),
('CalendarResizeAction',0,'',NULL,'N;'),
('CalendarResizeGoogleEvent',0,'',NULL,'N;'),
('CalendarSaveCheckedCalendar',0,'',NULL,'N;'),
('CalendarSaveCheckedCalendarFilter',0,'',NULL,'N;'),
('CalendarSaveGoogleEvent',0,'',NULL,'N;'),
('CalendarSearch',0,'',NULL,'N;'),
('CalendarSyncActionsToGoogleCalendar',0,'',NULL,'N;'),
('CalendarTogglePortletVisible',0,'',NULL,'N;'),
('CalendarToggleUserCalendarsVisible',0,'',NULL,'N;'),
('CalendarUncompleteAction',0,'',NULL,'N;'),
('CalendarUpdate',0,'',NULL,'N;'),
('CalendarUpdateAccess',1,'',NULL,'N;'),
('CalendarUserCalendarPermissions',0,'',NULL,'N;'),
('CalendarView',0,'',NULL,'N;'),
('CalendarViewAction',0,'',NULL,'N;'),
('CalendarViewGoogleEvent',0,'',NULL,'N;'),
('ChartsAdmin',0,'',NULL,'N;'),
('ChartsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ChartsAdminAccess',1,'',NULL,'N;'),
('ChartsDeleteNote',0,'',NULL,'N;'),
('ChartsFullAccess',1,'',NULL,'N;'),
('ChartsGetFieldData',0,'',NULL,'N;'),
('ChartsGetX2ModelInput',0,'',NULL,'N;'),
('ChartsIndex',0,'',NULL,'N;'),
('ChartsLeadVolume',0,'',NULL,'N;'),
('ChartsMarketing',0,'',NULL,'N;'),
('ChartsMinimumRequirements',1,'',NULL,'N;'),
('ChartsPipeline',0,'',NULL,'N;'),
('ChartsSales',0,'',NULL,'N;'),
('ChartsSearch',0,'',NULL,'N;'),
('ChartsWorkflow',0,'',NULL,'N;'),
('ContactsAddToList',0,'',NULL,'N;'),
('ContactsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ContactsAdmin',0,'',NULL,'N;'),
('ContactsAdminAccess',1,'The user has administrative access to the contacts module.',NULL,'N;'),
('ContactsBasicAccess',1,'The user can create and read.',NULL,'N;'),
('ContactsCreate',0,'',NULL,'N;'),
('ContactsCreateList',0,'',NULL,'N;'),
('ContactsCreateListFromSelection',0,'',NULL,'N;'),
('ContactsDelete',0,'',NULL,'N;'),
('ContactsDeleteList',0,'',NULL,'N;'),
('ContactsDeleteNote',0,'',NULL,'N;'),
('ContactsDeletePrivate',1,'This task allows a user to delete their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ContactsDiscardNew',0,'',NULL,'N;'),
('ContactsExportContacts',0,'',NULL,'N;'),
('ContactsFullAccess',1,'The user has full access to read, create, update, and delete features but lacks administrative permissions such as import/export.',NULL,'N;'),
('ContactsGetContacts',0,'',NULL,'N;'),
('ContactsGetItems',0,'',NULL,'N;'),
('ContactsGetLists',0,'',NULL,'N;'),
('ContactsGetTerms',0,'',NULL,'N;'),
('ContactsGetX2ModelInput',0,'',NULL,'N;'),
('ContactsIgnoreDuplicates',0,'',NULL,'N;'),
('ContactsPrepareImport',0,'',NULL,'N;'),
('ContactsCleanUpImport',0,'',NULL,'N;'),
('ContactsImportRecords',0,'',NULL,'N;'),
('ContactsImportExcel',0,'',NULL,'N;'),
('ContactsTrigger',0,'',NULL,'N;'),
('ContactsExportList',0,'',NULL,'N;'),
('ContactsExport',0,'',NULL,'N;'),
('ContactsExportSet',0,'',NULL,'N;'),
('ContactsIndex',0,'',NULL,'N;'),
('ContactsList',0,'',NULL,'N;'),
('ContactsLists',0,'',NULL,'N;'),
('ContactsMinimumRequirements',1,'Permissions required by anyone able to access the contacts module.',NULL,'N;'),
('ContactsMyContacts',0,'',NULL,'N;'),
('ContactsNewContacts',0,'',NULL,'N;'),
('ContactsPrivateFullAccess',1,'The user has full access to read and create, but can only update or delete records that are assigned to them.',NULL,'N;'),
('ContactsPrivateReadOnlyAccess',1,'The user can only view their own records.',NULL,'N;'),
('ContactsPrivateUpdateAccess',1,'The user can create and read, but only update their own records.',NULL,'N;'),
('ContactsQtip',0,'',NULL,'N;'),
('ContactsQuickContact',0,'',NULL,'N;'),
('ContactsReadOnlyAccess',1,'The user can only view records.',NULL,'N;'),
('ContactsRemoveFromList',0,'',NULL,'N;'),
('ContactsSearch',0,'',NULL,'N;'),
('ContactsShareContact',0,'',NULL,'N;'),
('ContactsSubscribe',0,'',NULL,'N;'),
('ContactsUpdate',0,'',NULL,'N;'),
('ContactsUpdateAccess',1,'The user has access to create, read, and update.',NULL,'N;'),
('ContactsUpdateList',0,'',NULL,'N;'),
('ContactsUpdatePrivate',1,'This task allows a user to update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ContactsView',0,'',NULL,'N;'),
('ContactsViewPrivate',1,'This task allows a user to view their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ContactsViewRelationships',0,'',NULL,'N;'),
('CredentialsAdmin',1,'Administrative credentials access',NULL,'N;'),
('CredentialsCreateUpdate',0,'Create or update credentials',NULL,'N;'),
('CredentialsCreateUpdateOwn',1,'Access to a user\'s own credentials, by the user','return Yii::app()->getUser()->getId() == $params[\'model\']->userId;','N;'),
('CredentialsCreateUpdateSystemwide',1,'Create or update system-wide credentials','return $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsDelete',0,'Delete a credentials record not in use.','','N;'),
('CredentialsDeleteOwn',1,'Delete one\'s own credentials.','return Yii::app()->getUser()->getId() == $params[\'model\']->userId;','N;'),
('CredentialsDeleteSystemwide',1,'Delete system-wide credentials that aren\'t in use','return (!$params[\'model\']->getIsInUseBySystem()) && $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsSelect',1,'Select a credentials record to use as default.',NULL,'N;'),
('CredentialsSelectOwn',1,'Select one\'s own credentials','return $params[\'model\']->userId == Yii::app()->user->id;','N;'),
('CredentialsSelectSystemwide',1,'Select system-owned credentials.','return $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('CredentialsSetDefault',0,'Set a credentials record as default.',NULL,'N;'),
('CredentialsSetDefaultOwn',1,'Set one\'s own credentials',NULL,'N;'),
('CredentialsSelectNonPrivate',1,'Select other users\' credentials that are designated not-private','return $params[\'model\']->private == 0;','N;'),
('CredentialsSetDefaultSystemwide',1,'Set system-wide default credentials, i.e. for bulk email.','return in_array($params[\'userId\'],Credentials::$sysUseId) && $params[\'model\']->userId == Credentials::SYS_ID;','N;'),
('DocsAdmin',0,'',NULL,'N;'),
('DocsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('DocsAdminAccess',1,'',NULL,'N;'),
('DocsAutosave',0,'',NULL,'N;'),
('DocsBasicAccess',1,'',NULL,'N;'),
('DocsChangePermissions',0,'',NULL,'N;'),
('DocsCreate',0,'',NULL,'N;'),
('DocsCreateEmail',0,'',NULL,'N;'),
('DocsCreateQuote',0,'',NULL,'N;'),
('DocsDelete',0,'',NULL,'N;'),
('DocsDeleteNote',0,'',NULL,'N;'),
('DocsDeletePrivate',1,'Users can delete their own docs','return Yii::app()->user->getName()==$params[\'createdBy\'];','N;'),
('DocsDownloadExport',0,'',NULL,'N;'),
('DocsExportToHtml',0,'',NULL,'N;'),
('DocsFullAccess',1,'',NULL,'N;'),
('DocsGetItem',0,'',NULL,'N;'),
('DocsGetItems',0,'',NULL,'N;'),
('DocsGetX2ModelInput',0,'',NULL,'N;'),
('DocsIndex',0,'',NULL,'N;'),
('DocsMinimumRequirements',1,'',NULL,'N;'),
('DocsPrivateFullAccess',1,'',NULL,'N;'),
('DocsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('DocsPrivateUpdateAccess',1,'',NULL,'N;'),
('DocsReadOnlyAccess',1,'',NULL,'N;'),
('DocsSearch',0,'',NULL,'N;'),
('DocsUpdate',0,'',NULL,'N;'),
('DocsUpdateAccess',1,'',NULL,'N;'),
('DocsUpdatePrivate',1,'Update their own docs','return Yii::app()->user->getName()==$params[\'createdBy\'];','N;'),
('DocsView',0,'',NULL,'N;'),
('DocsFullView',0,'',NULL,'N;'),
('DocsViewPrivate',1,'View their own docs','return Yii::app()->user->getName()==$params[\'createdBy\'];','N;'),
('DocsAjaxCheckEditPermission',0,'',NULL,'N;'),
('DropDownsTask',1,'Dropdown editor control.',NULL,'N;'),
('FieldsTask',1,'Field editor control.',NULL,'N;'),
('GeneralAdminSettingsTask',1,'A suite of application wide settings configurable by the administrator.',NULL,'N;'),
('GroupsAdmin',0,'',NULL,'N;'),
('GroupsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('GroupsAdminAccess',1,'',NULL,'N;'),
('GroupsBasicAccess',1,'',NULL,'N;'),
('GroupsCreate',0,'',NULL,'N;'),
('GroupsDelete',0,'',NULL,'N;'),
('GroupsDeleteNote',0,'',NULL,'N;'),
('GroupsFullAccess',1,'',NULL,'N;'),
('GroupsGetGroups',0,'',NULL,'N;'),
('GroupsGetX2ModelInput',0,'',NULL,'N;'),
('GroupsIndex',0,'',NULL,'N;'),
('GroupsMinimumRequirements',1,'',NULL,'N;'),
('GroupsReadOnlyAccess',1,'',NULL,'N;'),
('GroupsSearch',0,'',NULL,'N;'),
('GroupsUpdate',0,'',NULL,'N;'),
('GroupsUpdateAccess',1,'',NULL,'N;'),
('GroupsView',0,'',NULL,'N;'),
('guest',2,'Guest user','return Yii::app()->user->isGuest;','N;'),
('GuestSiteFunctionsTask',1,'A set of permissions required for guests to be able to log in and see the website.',NULL,'N;'),
('LeadRoutingTask',1,'A set of operations for configuring lead distribution.',NULL,'N;'),
('MarketingAdmin',0,'',NULL,'N;'),
('MarketingAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('MarketingAdminAccess',1,'',NULL,'N;'),
('MarketingBasicAccess',1,'',NULL,'N;'),
('MarketingBasicPrivate',1,'Control their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
/*('MarketingAjaxDeleteWebForm',0,'',NULL,'N;'),*/
('MarketingClick',0,'',NULL,'N;'),
('MarketingComplete',0,'',NULL,'N;'),
('MarketingCreate',0,'',NULL,'N;'),
('MarketingCreateFromTag',0,'',NULL,'N;'),
('MarketingDelete',0,'',NULL,'N;'),
('MarketingDeleteNote',0,'',NULL,'N;'),
('MarketingDeletePrivate',1,'Delete their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('MarketingFullAccess',1,'',NULL,'N;'),
('MarketingGetItems',0,'',NULL,'N;'),
('MarketingGetX2ModelInput',0,'',NULL,'N;'),
('MarketingIndex',0,'',NULL,'N;'),
('MarketingLaunch',0,'',NULL,'N;'),
('MarketingMailIndividual',0,'The AJAX action that sends mails in a batch sequence, one at a time.',NULL,'N;'),
('MarketingMinimumRequirements',1,'',NULL,'N;'),
('MarketingPrivateBasicAccess',1,'',NULL,'N;'),
('MarketingPrivateFullAccess',1,'',NULL,'N;'),
('MarketingPrivateReadOnlyAccess',1,'',NULL,'N;'),
('MarketingPrivateUpdateAccess',1,'',NULL,'N;'),
('MarketingReadOnlyAccess',1,'',NULL,'N;'),
('MarketingSearch',0,'',NULL,'N;'),
('MarketingToggle',0,'',NULL,'N;'),
('MarketingUpdate',0,'',NULL,'N;'),
('MarketingUpdateAccess',1,'',NULL,'N;'),
('MarketingUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('MarketingView',0,'',NULL,'N;'),
('MarketingViewPrivate',1,'View their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('MarketingWebLeadForm',0,'Edit the lead capture form.',NULL,'N;'),
('MarketingWebTracker',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingRemoveWebLeadFormCustomHtml',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingSaveWebLeadFormCustomHtml',0,'View embed code for web tracker.',NULL,'N;'),
('MarketingGetCampaignChartData',0,'View embed code for web tracker.',NULL,'N;'),
('MediaAdmin',0,'',NULL,'N;'),
('MediaAdminAccess',1,'',NULL,'N;'),
('MediaBasicAccess',1,'',NULL,'N;'),
('MediaDelete',0,'',NULL,'N;'),
('MediaDeleteNote',0,'',NULL,'N;'),
('MediaDownload',0,'',NULL,'N;'),
('MediaFullAccess',1,'',NULL,'N;'),
('MediaIndex',0,'',NULL,'N;'),
('MediaMinimumRequirements',1,'',NULL,'N;'),
('MediaReadOnlyAccess',1,'',NULL,'N;'),
('MediaSearch',0,'',NULL,'N;'),
('MediaToggleUserMediaVisible',0,'',NULL,'N;'),
('MediaUpdate',0,'',NULL,'N;'),
('MediaUpdateAccess',1,'',NULL,'N;'),
('MediaUpload',0,'',NULL,'N;'),
('MediaCreate',0,'',NULL,'N;'),
('MediaView',0,'',NULL,'N;'),
('MediaRecursiveDriveFiles',0,'',NULL,'N;'),
('MediaRefreshDriveCache',0,'',NULL,'N;'),
('MediaQtip',0,'',NULL,'N;'),
('OpportunitiesAddContact',0,'',NULL,'N;'),
('OpportunitiesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('OpportunitiesAddUser',0,'',NULL,'N;'),
('OpportunitiesAdmin',0,'',NULL,'N;'),
('OpportunitiesAdminAccess',1,'',NULL,'N;'),
('OpportunitiesBasicAccess',1,'',NULL,'N;'),
('OpportunitiesCreate',0,'',NULL,'N;'),
('OpportunitiesDelete',0,'',NULL,'N;'),
('OpportunitiesDeleteNote',0,'',NULL,'N;'),
('OpportunitiesDeletePrivate',1,'Delete their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('OpportunitiesFullAccess',1,'',NULL,'N;'),
('OpportunitiesGetItems',0,'',NULL,'N;'),
('OpportunitiesGetTerms',0,'',NULL,'N;'),
('OpportunitiesGetX2ModelInput',0,'',NULL,'N;'),
('OpportunitiesIndex',0,'',NULL,'N;'),
('OpportunitiesMinimumRequirements',1,'',NULL,'N;'),
('OpportunitiesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('OpportunitiesPrivateUpdateAccess',1,'',NULL,'N;'),
('OpportunitiesReadOnlyAccess',1,'',NULL,'N;'),
('OpportunitiesRemoveContact',0,'',NULL,'N;'),
('OpportunitiesRemoveUser',0,'',NULL,'N;'),
('OpportunitiesSearch',0,'',NULL,'N;'),
('OpportunitiesShareOpportunity',0,'',NULL,'N;'),
('OpportunitiesUpdate',0,'',NULL,'N;'),
('OpportunitiesUpdateAccess',1,'',NULL,'N;'),
('OpportunitiesUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('OpportunitiesView',0,'',NULL,'N;'),
('OpportunitiesViewPrivate',1,'View their own record','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('OpporunitiesPrivateFullAccess',1,'',NULL,'N;'),
('ProductsAdmin',0,'',NULL,'N;'),
('ProductsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ProductsAdminAccess',1,'',NULL,'N;'),
('ProductsBasicAccess',1,'',NULL,'N;'),
('ProductsCreate',0,'',NULL,'N;'),
('ProductsDelete',0,'',NULL,'N;'),
('ProductsDeleteNote',0,'',NULL,'N;'),
('ProductsDeletePrivate',1,'Delete their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ProductsFullAccess',1,'',NULL,'N;'),
('ProductsGetItems',0,'',NULL,'N;'),
('ProductsGetX2ModelInput',0,'',NULL,'N;'),
('ProductsIndex',0,'',NULL,'N;'),
('ProductsMinimumRequirements',1,'',NULL,'N;'),
('ProductsPrivateFullAccess',1,'',NULL,'N;'),
('ProductsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ProductsPrivateUpdateAccess',1,'',NULL,'N;'),
('ProductsReadOnlyAccess',1,'',NULL,'N;'),
('ProductsSearch',0,'',NULL,'N;'),
('ProductsUpdate',0,'',NULL,'N;'),
('ProductsUpdateAccess',1,'',NULL,'N;'),
('ProductsUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ProductsView',0,'',NULL,'N;'),
('ProductsViewPrivate',1,'View their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('QuotesAddContact',0,'',NULL,'N;'),
('QuotesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('QuotesAddProduct',0,'',NULL,'N;'),
('QuotesAddUser',0,'',NULL,'N;'),
('QuotesAdmin',0,'',NULL,'N;'),
('QuotesAdminAccess',1,'',NULL,'N;'),
('QuotesBasicAccess',1,'',NULL,'N;'),
('QuotesCreate',0,'',NULL,'N;'),
('QuotesDelete',0,'',NULL,'N;'),
('QuotesDeleteNote',0,'',NULL,'N;'),
('QuotesDeletePrivate',1,'Delete their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('QuotesDeleteProduct',0,'',NULL,'N;'),
('QuotesFullAccess',1,'',NULL,'N;'),
('QuotesGetItems',0,'',NULL,'N;'),
('QuotesGetTerms',0,'',NULL,'N;'),
('QuotesGetX2ModelInput',0,'',NULL,'N;'),
('QuotesIndex',0,'',NULL,'N;'),
('QuotesMinimumRequirements',1,'',NULL,'N;'),
('QuotesPrint',0,'',NULL,'N;'),
('QuotesPrivateFullAccess',1,'',NULL,'N;'),
('QuotesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('QuotesPrivateUpdateAccess',1,'',NULL,'N;'),
('QuotesQuickCreate',0,'',NULL,'N;'),
('QuotesQuickDelete',0,'',NULL,'N;'),
('QuotesQuickUpdate',0,'',NULL,'N;'),
('QuotesReadOnlyAccess',1,'',NULL,'N;'),
('QuotesRemoveContact',0,'',NULL,'N;'),
('QuotesRemoveUser',0,'',NULL,'N;'),
('QuotesSearch',0,'',NULL,'N;'),
('QuotesShareQuote',0,'',NULL,'N;'),
('QuotesUpdate',0,'',NULL,'N;'),
('QuotesUpdateAccess',1,'',NULL,'N;'),
('QuotesUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('QuotesView',0,'',NULL,'N;'),
('QuotesViewInline',0,'',NULL,'N;'),
('QuotesViewPrivate',1,'View their own record','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ReportsActivityReport',0,'',NULL,'N;'),
('ReportsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ReportsAdmin',0,'',NULL,'N;'),
('ReportsAdminAccess',1,'',NULL,'N;'),
('ReportsDealReport',0,'',NULL,'N;'),
('ReportsDelete',0,'',NULL,'N;'),
('ReportsDeleteNote',0,'',NULL,'N;'),
('ReportsFullAccess',1,'',NULL,'N;'),
('ReportsGetOptions',0,'',NULL,'N;'),
('ReportsGetX2ModelInput',0,'',NULL,'N;'),
('ReportsGridReport',0,'',NULL,'N;'),
('ReportsIndex',0,'',NULL,'N;'),
('ReportsLeadPerformance',0,'',NULL,'N;'),
('ReportsMinimumRequirements',1,'',NULL,'N;'),
('ReportsPrintReport',0,'',NULL,'N;'),
('ReportsSavedReports',0,'',NULL,'N;'),
('ReportsSaveReport',0,'',NULL,'N;'),
('ReportsSaveTempImage',0,'',NULL,'N;'),
('ReportsSearch',0,'',NULL,'N;'),
('ReportsWorkflow',0,'',NULL,'N;'),
('RoleAccessTask',1,'A set of operations for managing roles.',NULL,'N;'),
('ServicesAdmin',0,'',NULL,'N;'),
('ServicesAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('ServicesAdminAccess',1,'',NULL,'N;'),
('ServicesBasicAccess',1,'',NULL,'N;'),
('ServicesCreate',0,'',NULL,'N;'),
('ServicesDelete',0,'',NULL,'N;'),
('ServicesDeleteNote',0,'',NULL,'N;'),
('ServicesDeletePrivate',1,'Delete their own records.','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ServicesFullAccess',1,'',NULL,'N;'),
('ServicesGetItems',0,'',NULL,'N;'),
('ServicesGetX2ModelInput',0,'',NULL,'N;'),
('ServicesIndex',0,'',NULL,'N;'),
('ServicesMinimumRequirements',1,'',NULL,'N;'),
('ServicesPrivateFullAccess',1,'',NULL,'N;'),
('ServicesPrivateReadOnlyAccess',1,'',NULL,'N;'),
('ServicesPrivateUpdateAccess',1,'',NULL,'N;'),
('ServicesReadOnlyAccess',1,'',NULL,'N;'),
('ServicesSearch',0,'',NULL,'N;'),
('ServicesUpdate',0,'',NULL,'N;'),
('ServicesUpdateAccess',1,'',NULL,'N;'),
('ServicesUpdatePrivate',1,'Update their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ServicesView',0,'',NULL,'N;'),
('ServicesViewPrivate',1,'View their own records','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('ServicesCreateWebForm',0,'Edit the web form.',NULL,'N;'),
('ServicesServicesReport',0,'',NULL,'N;'),
('ServicesExportServiceReport',0,'',NULL,'N;'),
('SiteIndex',0,'Index of SiteController.',NULL,'N;'),
('SiteLogin',0,'Log in to the software.',NULL,'N;'),
('SiteLogout',0,'Logout out of the software.',NULL,'N;'),
('SiteToggleVisibility',0,'Toglge visible/invisible user status.',NULL,'N;'),
('SiteWhatsNew',0,'What\'s New page of the app.',NULL,'N;'),
('TranslationsTask',1,'A set of permissions required to access translation features.',NULL,'N;'),
('UsersAddTopContact',0,'',NULL,'N;'),
('UsersAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('UsersAdmin',0,'',NULL,'N;'),
('UsersAdminAccess',1,'',NULL,'N;'),
('UsersBasicAccess',1,'',NULL,'N;'),
('UsersCreate',0,'',NULL,'N;'),
('UsersCreateAccount',0,'',NULL,'N;'),
('UsersDelete',0,'',NULL,'N;'),
('UsersDeleteNote',0,'',NULL,'N;'),
('UsersFullAccess',1,'',NULL,'N;'),
('UsersGetX2ModelInput',0,'',NULL,'N;'),
('UsersIndex',0,'',NULL,'N;'),
('UsersInviteUsers',0,'',NULL,'N;'),
('UsersMinimumRequirements',1,'',NULL,'N;'),
('UsersReadOnlyAccess',1,'',NULL,'N;'),
('UsersRemoveTopContact',0,'',NULL,'N;'),
('UsersSearch',0,'',NULL,'N;'),
('UsersUpdate',0,'',NULL,'N;'),
('UsersUpdateAccess',1,'',NULL,'N;'),
('UsersView',0,'',NULL,'N;'),
('WeblistCreate',0,'',NULL,'N;'),
('WeblistAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('WeblistDelete',0,'',NULL,'N;'),
('WeblistIndex',0,'',NULL,'N;'),
('WeblistUpdate',0,'',NULL,'N;'),
('WeblistView',0,'',NULL,'N;'),
('WeblistGetX2ModelInput',0,'',NULL,'N;'),
('WorkflowAdmin',0,'',NULL,'N;'),
('WorkflowAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('WorkflowAdminAccess',1,'',NULL,'N;'),
('WorkflowBasicAccess',1,'',NULL,'N;'),
('WorkflowCompleteStage',0,'',NULL,'N;'),
('WorkflowCreate',0,'',NULL,'N;'),
('WorkflowDelete',0,'',NULL,'N;'),
('WorkflowDeleteNote',0,'',NULL,'N;'),
('WorkflowFullAccess',1,'',NULL,'N;'),
('WorkflowGetStageDetails',0,'',NULL,'N;'),
('WorkflowGetStageMembers',0,'',NULL,'N;'),
('WorkflowGetStages',0,'',NULL,'N;'),
('WorkflowGetWorkflow',0,'',NULL,'N;'),
('WorkflowGetX2ModelInput',0,'',NULL,'N;'),
('WorkflowIndex',0,'',NULL,'N;'),
('WorkflowMinimumRequirements',1,'',NULL,'N;'),
('WorkflowReadOnlyAccess',1,'',NULL,'N;'),
('WorkflowRevertStage',0,'',NULL,'N;'),
('WorkflowSearch',0,'',NULL,'N;'),
('WorkflowStartStage',0,'',NULL,'N;'),
('WorkflowUpdate',0,'',NULL,'N;'),
('WorkflowUpdateAccess',1,'',NULL,'N;'),
('WorkflowUpdateStageDetails',0,'',NULL,'N;'),
('WorkflowView',0,'',NULL,'N;'),
('WorkflowViewStage',0,'',NULL,'N;'),
('WorkflowGetStageValue',0,'',NULL,'N;'),
('X2StudioTask',1,'A set of permissions for the use of X2Studio.',NULL,'N;'),
('AdminCalculateTranslationRedundancy',0,'',NULL,'N;'),
('AdminFindMissingPermissions',0,'',NULL,'N;'),
('AdminGetWorkflowStages',0,'',NULL,'N;'),
('AdminGetRole',0,'',NULL,'N;'),
('AdminDeleteCriteria',0,'',NULL,'N;'),
('AdminDeleteRouting',0,'',NULL,'N;'),
('AdminGetAttributes',0,'',NULL,'N;'),
('AdminActivitySettings',0,'',NULL,'N;'),
('AdminSetServiceRouting',0,'',NULL,'N;'),
('AdminValidateField',0,'',NULL,'N;'),
('AdminRemoveField',0,'',NULL,'N;'),
('AdminGetFieldData',0,'',NULL,'N;'),
('AdminViewPage',0,'',NULL,'N;'),
('AdminRegisterModules',0,'',NULL,'N;'),
('AdminToggleModule',0,'',NULL,'N;'),
('AdminCreateFormLayout',0,'',NULL,'N;'),
('AdminDeleteFormLayout',0,'',NULL,'N;'),
('AdminGetDropdown',0,'',NULL,'N;'),
('AdminGetFieldType',0,'',NULL,'N;'),
('AdminDelete',0,'',NULL,'N;'),
('AdminInstallUpdate',0,'',NULL,'N;'),
('AdminCleanUp',0,'',NULL,'N;'),
('AdminViewLogs',0,'',NULL,'N;'),
('AdminAuthGraph',0,'',NULL,'N;'),
('AdminFlowDesigner',0,'',NULL,'N;'),
('AdminGetRoutingType',0,'',NULL,'N;'),
('ActionsViewEmail',0,'',NULL,'N;'),
('ActionsEmailOpened',0,'',NULL,'N;'),
('CalendarList',0,'',NULL,'N;'),
('ContactsRevisions',0,'',NULL,'N;'),
('ContactsSyncAccount',0,'',NULL,'N;'),
('ContactsGoogleMaps',0,'',NULL,'N;'),
('ContactsSaveMap',0,'',NULL,'N;'),
('ContactsSavedMaps',0,'',NULL,'N;'),
('ContactsDeleteMap',0,'',NULL,'N;'),
('ContactsUpdateLocation',0,'',NULL,'N;'),
('ContactsCleanFailedLeads',0,'',NULL,'N;'),
('ContactsWeblead',0,'',NULL,'N;'),
('MarketingViewContent',0,'',NULL,'N;'),
('WeblistWeblist',0,'',NULL,'N;'),
('WeblistDeleteNote',0,'',NULL,'N;'),
('WeblistSearch',0,'',NULL,'N;'),
('MediaAjaxUpload',0,'',NULL,'N;'),
('MediaAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('MediaGetX2ModelInput',0,'',NULL,'N;'),
('QuotesIndexInvoice',0,'',NULL,'N;'),
('QuotesConvertToInvoice',0,'',NULL,'N;'),
('ServicesWebForm',0,'',NULL,'N;'),
('ServicesStatusFilter',0,'',NULL,'N;'),
('UsersDeleteTemporary',0,'',NULL,'N;'),
('BugReportsIndex',0,'',NULL,'N;'),
('BugReportsAjaxGetModelAutocomplete',0,'',NULL,'N;'),
('BugReportsAdmin',0,'',NULL,'N;'),
('BugReportsView',0,'',NULL,'N;'),
('BugReportsCreate',0,'',NULL,'N;'),
('BugReportsUpdate',0,'',NULL,'N;'),
('BugReportsDelete',0,'',NULL,'N;'),
('BugReportsGetItems',0,'',NULL,'N;'),
('BugReportsGetX2ModelInput',0,'',NULL,'N;'),
('BugReportsStatusFilter',0,'',NULL,'N;'),
('BugReportsDeleteNote',0,'',NULL,'N;'),
('BugReportsSearch',0,'',NULL,'N;'),
('BugReportsMinimumRequirements',1,'',NULL,'N;'),
('BugReportsReadOnlyAccess',1,'',NULL,'N;'),
('BugReportsPrivateReadOnlyAccess',1,'',NULL,'N;'),
('BugReportsBasicAccess',1,'',NULL,'N;'),
('BugReportsPrivateUpdateAccess',1,'',NULL,'N;'),
('BugReportsUpdateAccess',1,'',NULL,'N;'),
('BugReportsFullAccess',1,'',NULL,'N;'),
('BugReportsPrivateFullAccess',1,'',NULL,'N;'),
('BugReportsAdminAccess',1,'',NULL,'N;'),
('BugReportsViewPrivate',1,'','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('BugReportsUpdatePrivate',1,'','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;'),
('BugReportsDeletePrivate',1,'','return Yii::app()->user->getName()==$params[\'assignedTo\'];','N;');
/*&*/
INSERT INTO `x2_auth_item_child` (`parent`,`child`) VALUES
('AccountsUpdateAccess','AccountsAddUser'),
('AccountsUpdatePrivate','AccountsAddUser'),
('AccountsAdminAccess','AccountsAdmin'),
('administrator','AccountsAdminAccess'),
('AccountsPrivateUpdateAccess','AccountsBasicAccess'),
('AccountsUpdateAccess','AccountsBasicAccess'),
('AccountsBasicAccess','AccountsCreate'),
('AccountsIndex','AccountsAjaxGetModelAutocomplete'),
('AccountsDeletePrivate','AccountsDelete'),
('AccountsFullAccess','AccountsDelete'),
('AccountsFullAccess','AccountsDeleteNote'),
('AccountsPrivateFullAccess','AccountsDeleteNote'),
('AccountsPrivateFullAccess','AccountsDeletePrivate'),
('AccountsAdminAccess','AccountsFullAccess'),
('AccountsMinimumRequirements','AccountsGetItems'),
('AccountsMinimumRequirements','AccountsIndex'),
('AccountsPrivateReadOnlyAccess','AccountsMinimumRequirements'),
('AccountsReadOnlyAccess','AccountsMinimumRequirements'),
('AccountsPrivateFullAccess','AccountsPrivateUpdateAccess'),
('AccountsBasicAccess','AccountsReadOnlyAccess'),
('AccountsUpdateAccess','AccountsRemoveUser'),
('AccountsUpdatePrivate','AccountsRemoveUser'),
('AccountsMinimumRequirements','AccountsSearch'),
('AccountsReadOnlyAccess','AccountsShareAccount'),
('AccountsViewPrivate','AccountsShareAccount'),
('AccountsUpdateAccess','AccountsUpdate'),
('AccountsUpdateAccess','AccountsGetX2ModelInput'),
('AccountsUpdatePrivate','AccountsUpdate'),
('AccountsFullAccess','AccountsUpdateAccess'),
('DefaultRole','AccountsUpdateAccess'),
('AccountsPrivateUpdateAccess','AccountsUpdatePrivate'),
('AccountsReadOnlyAccess','AccountsView'),
('AccountsViewPrivate','AccountsView'),
('AccountsPrivateReadOnlyAccess','AccountsViewPrivate'),
('ActionsAdminAccess','ActionsAdmin'),
('administrator','ActionsAdminAccess'),
('ActionsPrivateUpdateAccess','ActionsBasicAccess'),
('ActionsUpdateAccess','ActionsBasicAccess'),
('ActionsUpdateAccess','ActionsComplete'),
('ActionsReadOnlyAccess','ActionsViewAction'),
('ActionsUpdatePrivate','ActionsComplete'),
('ActionsViewPrivate','ActionsViewAction'),
('ActionsReadOnlyAccess','ActionsCompleteSelected'),
('ActionsViewPrivate','ActionsCompleteSelected'),
('ActionsBasicAccess','ActionsCreate'),
('ActionsIndex','ActionsAjaxGetModelAutocomplete'),
('ActionsDeletePrivate','ActionsDelete'),
('ActionsFullAccess','ActionsDelete'),
('ActionsFullAccess','ActionsDeleteNote'),
('ActionsPrivateFullAccess','ActionsDeleteNote'),
('ActionsPrivateFullAccess','ActionsDeletePrivate'),
('ActionsAdminAccess','ActionsFullAccess'),
('ActionsMinimumRequirements','ActionsGetTerms'),
('ActionsMinimumRequirements','ActionsIndex'),
('ActionsMinimumRequirements','ActionsInvalid'),
('ActionsPrivateReadOnlyAccess','ActionsMinimumRequirements'),
('ActionsReadOnlyAccess','ActionsMinimumRequirements'),
('ActionsMinimumRequirements','ActionsParseType'),
('ActionsPrivateFullAccess','ActionsPrivateUpdateAccess'),
('ActionsBasicAccess','ActionsPublisherCreate'),
('GuestSiteFunctionsTask','ActionsPublisherCreate'),
('ActionsUpdateAccess','ActionsQuickUpdate'),
('ActionsUpdateAccess','ActionsToggleSticky'),
('ActionsUpdatePrivate','ActionsQuickUpdate'),
('ActionsUpdatePrivate','ActionsToggleSticky'),
('ActionsBasicAccess','ActionsReadOnlyAccess'),
('ActionsMinimumRequirements','ActionsSaveShowActions'),
('ActionsMinimumRequirements','ActionsSearch'),
('GuestSiteFunctionsTask','ActionsSendReminder'),
('GuestSiteFunctionsTask','ActionsViewEmail'),
('ActionsReadOnlyAccess','ActionsSendReminder'),
('ActionsViewPrivate','ActionsSendReminder'),
('ActionsReadOnlyAccess','ActionsShareAction'),
('ActionsViewPrivate','ActionsShareAction'),
('ActionsUpdateAccess','ActionsTimerControl'),
('ActionsReadOnlyAccess','ActionsTomorrow'),
('ActionsViewPrivate','ActionsTomorrow'),
('ActionsReadOnlyAccess','ActionsUncomplete'),
('ActionsViewPrivate','ActionsUncomplete'),
('ActionsReadOnlyAccess','ActionsUncompleteSelected'),
('ActionsViewPrivate','ActionsUncompleteSelected'),
('ActionsUpdateAccess','ActionsUpdate'),
('ActionsUpdateAccess','ActionsGetX2ModelInput'),
('ActionsUpdatePrivate','ActionsUpdate'),
('ActionsFullAccess','ActionsUpdateAccess'),
('DefaultRole','ActionsPrivateFullAccess'),
('ActionsPrivateUpdateAccess','ActionsUpdatePrivate'),
('ActionsReadOnlyAccess','ActionsView'),
('ActionsViewPrivate','ActionsView'),
('ActionsMinimumRequirements','ActionsViewAll'),
('ActionsMinimumRequirements','ActionsViewGroup'),
('ActionsPrivateReadOnlyAccess','ActionsViewPrivate'),
('LeadRoutingTask','AdminAddCriteria'),
('FieldsTask','AdminCreateUpdateField'),
('GeneralAdminSettingsTask','AdminChangeApplicationName'),
('GeneralAdminSettingsTask','AdminAppSettings'),
('GeneralAdminSettingsTask','AdminManageTags'),
('GeneralAdminSettingsTask','AdminDeleteTag'),
('GeneralAdminSettingsTask','AdminPrepareImport'),
('GeneralAdminSettingsTask','AdminGlobalImport'),
('GeneralAdminSettingsTask','AdminCleanUpImport'),
('GeneralAdminSettingsTask','AdminPrepareExport'),
('GeneralAdminSettingsTask','AdminGlobalExport'),
('GeneralAdminSettingsTask','AdminPublicInfo'),
('GeneralAdminSettingsTask','AdminRollbackImport'),
('GeneralAdminSettingsTask','AdminRollbackStage'),
('GeneralAdminSettingsTask','AdminViewSessionLog'),
('GeneralAdminSettingsTask','AdminViewSessionHistory'),
('GeneralAdminSettingsTask','AdminBackup'),
('GeneralAdminSettingsTask','AdminCheckDatabaseBackup'),
('AuthenticatedSiteFunctionsTask','AdminDownloadData'),
('X2StudioTask','AdminCreateModule'),
('GeneralAdminSettingsTask','AdminCreatePage'),
('DropDownsTask','AdminDeleteDropdown'),
('FieldsTask','AdminDeleteField'),
('X2StudioTask','AdminDeleteModule'),
('RoleAccessTask','AdminDeleteRole'),
('DropDownsTask','AdminDropDownEditor'),
('DropDownsTask','AdminEditDropdown'),
('X2StudioTask','AdminEditor'),
('RoleAccessTask','AdminEditRole'),
('GeneralAdminSettingsTask','AdminEmailSetup'),
('GeneralAdminSettingsTask','AdminExport'),
('X2StudioTask','AdminExportModule'),
('AdminExport','AdminExportModels'),
('AdminExport','AdminExportModelRecords'),
('AdminImport','AdminImportModels'),
('AdminImport','AdminImportModelRecords'),
('AdminImport','AdminPrepareModelImport'),
('AdminImport','AdminCleanUpModelImport'),
('GeneralAdminSettingsTask','AdminGoogleIntegration'),
('GeneralAdminSettingsTask','AdminImport'),
('X2StudioTask','AdminImportModule'),
('GeneralAdminSettingsTask','AdminIndex'),
('TranslationsTask','AdminIndex'),
('DropDownsTask','AdminManageDropDowns'),
('FieldsTask','AdminManageFields'),
('GeneralAdminSettingsTask','AdminManageModules'),
('GeneralAdminSettingsTask','AdminWorkflowSettings'),
('GeneralAdminSettingsTask','AdminUpdater'),
('GeneralAdminSettingsTask','AdminUpdateStage'),
('GeneralAdminSettingsTask','AdminUpdaterSettings'),
('GeneralAdminSettingsTask','AdminManageSessions'),
('GeneralAdminSettingsTask','AdminToggleSession'),
('GeneralAdminSettingsTask','AdminEndSession'),
('RoleAccessTask','AdminManageRoles'),
('X2StudioTask','AdminRenameModules'),
('RoleAccessTask','AdminRoleEditor'),
('RoleAccessTask','AdminRoleException'),
('LeadRoutingTask','AdminRoundRobinRules'),
('LeadRoutingTask','AdminSetLeadRouting'),
('GeneralAdminSettingsTask','AdminToggleDefaultLogo'),
('TranslationsTask','AdminTranslationManager'),
('GeneralAdminSettingsTask','AdminUploadLogo'),
('GeneralAdminSettingsTask','AdminViewChangelog'),
('GeneralAdminSettingsTask','AdminClearChangelog'),
('administrator','authenticated'),
('administrator','AdminIndex'),
('DefaultRole','AuthenticatedSiteFunctionsTask'),
('CalendarAdminAccess','CalendarAdmin'),
('administrator','CalendarAdminAccess'),
('CalendarUpdateAccess','CalendarBasicAccess'),
('CalendarUpdateAccess','CalendarCompleteAction'),
('CalendarBasicAccess','CalendarCreate'),
('CalendarIndex','CalendarAjaxGetModelAutocomplete'),
('CalendarFullAccess','CalendarDelete'),
('CalendarFullAccess','CalendarDeleteAction'),
('CalendarFullAccess','CalendarDeleteGoogleEvent'),
('CalendarFullAccess','CalendarDeleteNote'),
('CalendarUpdateAccess','CalendarEditAction'),
('CalendarUpdateAccess','CalendarEditGoogleEvent'),
('CalendarAdminAccess','CalendarFullAccess'),
('CalendarMinimumRequirements','CalendarIndex'),
('CalendarMinimumRequirements','CalendarJsonFeed'),
('CalendarMinimumRequirements','CalendarJsonFeedGoogle'),
('CalendarMinimumRequirements','CalendarJsonFeedGroup'),
('CalendarMinimumRequirements','CalendarJsonFeedShared'),
('CalendarReadOnlyAccess','CalendarMinimumRequirements'),
('CalendarUpdateAccess','CalendarMoveAction'),
('CalendarUpdateAccess','CalendarMoveGoogleEvent'),
('CalendarMinimumRequirements','CalendarMyCalendarPermissions'),
('CalendarBasicAccess','CalendarReadOnlyAccess'),
('CalendarUpdateAccess','CalendarResizeAction'),
('CalendarUpdateAccess','CalendarResizeGoogleEvent'),
('CalendarMinimumRequirements','CalendarSaveCheckedCalendar'),
('CalendarMinimumRequirements','CalendarSaveCheckedCalendarFilter'),
('CalendarBasicAccess','CalendarSaveGoogleEvent'),
('CalendarMinimumRequirements','CalendarSearch'),
('CalendarBasicAccess','CalendarSyncActionsToGoogleCalendar'),
('CalendarMinimumRequirements','CalendarTogglePortletVisible'),
('CalendarMinimumRequirements','CalendarToggleUserCalendarsVisible'),
('CalendarUpdateAccess','CalendarUncompleteAction'),
('CalendarUpdateAccess','CalendarUpdate'),
('DefaultRole','CalendarFullAccess'),
('CalendarFullAccess','CalendarUpdateAccess'),
('CalendarAdminAccess','CalendarUserCalendarPermissions'),
('CalendarReadOnlyAccess','CalendarView'),
('CalendarReadOnlyAccess','CalendarViewAction'),
('CalendarReadOnlyAccess','CalendarViewGoogleEvent'),
('ChartsAdminAccess','ChartsAdmin'),
('ChartsIndex','ChartsAjaxGetModelAutocomplete'),
('administrator','ChartsAdminAccess'),
('ChartsFullAccess','ChartsDeleteNote'),
('DefaultRole','ChartsFullAccess'),
('ChartsAdminAccess','ChartsFullAccess'),
('ChartsMinimumRequirements','ChartsGetFieldData'),
('ChartsMinimumRequirements','ChartsIndex'),
('ChartsFullAccess','ChartsLeadVolume'),
('ChartsFullAccess','ChartsMarketing'),
('ChartsFullAccess','ChartsMinimumRequirements'),
('ChartsFullAccess','ChartsPipeline'),
('ChartsFullAccess','ChartsSales'),
('ChartsMinimumRequirements','ChartsSearch'),
('ChartsFullAccess','ChartsWorkflow'),
('ContactsBasicAccess','ContactsAddToList'),
('ContactsIndex','ContactsAjaxGetModelAutocomplete'),
('ContactsAdminAccess','ContactsAdmin'),
('administrator','ContactsAdminAccess'),
('ContactsPrivateUpdateAccess','ContactsBasicAccess'),
('ContactsUpdateAccess','ContactsBasicAccess'),
('ContactsBasicAccess','ContactsCreate'),
('ContactsBasicAccess','ContactsCreateList'),
('ContactsBasicAccess','ContactsCreateListFromSelection'),
('ContactsDeletePrivate','ContactsDelete'),
('ContactsFullAccess','ContactsDelete'),
('ContactsDeletePrivate','ContactsDeleteList'),
('ContactsFullAccess','ContactsDeleteList'),
('ContactsFullAccess','ContactsDeleteNote'),
('ContactsPrivateFullAccess','ContactsDeleteNote'),
('ContactsPrivateFullAccess','ContactsDeletePrivate'),
('ContactsMinimumRequirements','ContactsDiscardNew'),
('ContactsAdminAccess','ContactsExportContacts'),
('ContactsAdminAccess','ContactsFullAccess'),
('ContactsMinimumRequirements','ContactsGetContacts'),
('ContactsMinimumRequirements','ContactsGetItems'),
('ContactsMinimumRequirements','ContactsGetLists'),
('ContactsMinimumRequirements','ContactsGetTerms'),
('ContactsMinimumRequirements','ContactsIgnoreDuplicates'),
('ContactsAdminAccess','ContactsPrepareImport'),
('ContactsAdminAccess','ContactsCleanUpImport'),
('ContactsAdminAccess','ContactsImportRecords'),
('ContactsAdminAccess','ContactsImportExcel'),
('ContactsAdminAccess','ContactsExportList'),
('ContactsAdminAccess','ContactsExport'),
('ContactsAdminAccess','ContactsExportSet'),
('ContactsAdminAccess','ContactsTrigger'),
('ContactsMinimumRequirements','ContactsIndex'),
('ContactsMinimumRequirements','ContactsList'),
('ContactsMinimumRequirements','ContactsLists'),
('ContactsPrivateReadOnlyAccess','ContactsMinimumRequirements'),
('ContactsReadOnlyAccess','ContactsMinimumRequirements'),
('ContactsMinimumRequirements','ContactsMyContacts'),
('ContactsMinimumRequirements','ContactsNewContacts'),
('ContactsPrivateFullAccess','ContactsPrivateUpdateAccess'),
('ContactsMinimumRequirements','ContactsQtip'),
('ContactsBasicAccess','ContactsQuickContact'),
('ContactsBasicAccess','ContactsReadOnlyAccess'),
('ContactsUpdateAccess','ContactsRemoveFromList'),
('ContactsUpdatePrivate','ContactsRemoveFromList'),
('ContactsMinimumRequirements','ContactsSearch'),
('ContactsReadOnlyAccess','ContactsShareContact'),
('ContactsViewPrivate','ContactsShareContact'),
('ContactsReadOnlyAccess','ContactsSubscribe'),
('ContactsViewPrivate','ContactsSubscribe'),
('ContactsUpdateAccess','ContactsUpdate'),
('ContactsUpdateAccess','ContactsGetX2ModelInput'),
('ContactsUpdatePrivate','ContactsUpdate'),
('DefaultRole','ContactsUpdateAccess'),
('ContactsFullAccess','ContactsUpdateAccess'),
('ContactsPrivateUpdateAccess','ContactsUpdateList'),
('ContactsUpdateAccess','ContactsUpdateList'),
('ContactsPrivateUpdateAccess','ContactsUpdatePrivate'),
('ContactsReadOnlyAccess','ContactsView'),
('ContactsViewPrivate','ContactsView'),
('ContactsPrivateReadOnlyAccess','ContactsViewPrivate'),
('ContactsReadOnlyAccess','ContactsViewRelationships'),
('ContactsViewPrivate','ContactsViewRelationships'),
('DocsAdminAccess','DocsAdmin'),
('administrator','DocsAdminAccess'),
('DocsMinimumRequirements','DocsAutosave'),
('DocsPrivateUpdateAccess','DocsBasicAccess'),
('DocsUpdateAccess','DocsBasicAccess'),
('DefaultRole','DocsUpdatePrivate'),
('DocsUpdatePrivate','DocsChangePermissions'),
('DocsBasicAccess','DocsCreate'),
('DocsIndex','DocsAjaxGetModelAutocomplete'),
('DocsBasicAccess','DocsCreateEmail'),
('DocsBasicAccess','DocsCreateQuote'),
('DocsDeletePrivate','DocsDelete'),
('DocsFullAccess','DocsDelete'),
('DocsFullAccess','DocsDeleteNote'),
('DocsPrivateFullAccess','DocsDeleteNote'),
('DocsPrivateFullAccess','DocsDeletePrivate'),
('DocsReadOnlyAccess','DocsExportToHtml'),
('DocsViewPrivate','DocsExportToHtml'),
('DocsExportToHtml','DocsDownloadExport'),
('DocsAdminAccess','DocsFullAccess'),
('DocsMinimumRequirements','DocsGetItem'),
('DocsMinimumRequirements','DocsGetItems'),
('DocsMinimumRequirements','DocsIndex'),
('DocsPrivateReadOnlyAccess','DocsMinimumRequirements'),
('DocsReadOnlyAccess','DocsMinimumRequirements'),
('DocsPrivateFullAccess','DocsPrivateUpdateAccess'),
('DocsBasicAccess','DocsReadOnlyAccess'),
('DocsMinimumRequirements','DocsSearch'),
('DocsUpdateAccess','DocsUpdate'),
('DocsUpdateAccess','DocsGetX2ModelInput'),
('DocsUpdatePrivate','DocsUpdate'),
('DefaultRole','DocsUpdateAccess'),
('DocsFullAccess','DocsUpdateAccess'),
('DocsPrivateUpdateAccess','DocsUpdatePrivate'),
('DocsReadOnlyAccess','DocsView'),
('DocsReadOnlyAccess','DocsFullView'),
('DocsViewPrivate','DocsView'),
('DocsViewPrivate','DocsFullView'),
('DocsPrivateReadOnlyAccess','DocsViewPrivate'),
('DocsMinimumRequirements','DocsAjaxCheckEditPermission'),
('X2StudioTask','DropDownsTask'),
('X2StudioTask','FieldsTask'),
('administrator','GeneralAdminSettingsTask'),
('GroupsAdminAccess','GroupsAdmin'),
('administrator','GroupsAdminAccess'),
('GroupsUpdateAccess','GroupsBasicAccess'),
('GroupsBasicAccess','GroupsCreate'),
('GroupsIndex','GroupsAjaxGetModelAutocomplete'),
('GroupsFullAccess','GroupsDelete'),
('GroupsFullAccess','GroupsDeleteNote'),
('GroupsAdminAccess','GroupsFullAccess'),
('GroupsMinimumRequirements','GroupsGetGroups'),
('GroupsMinimumRequirements','GroupsIndex'),
('GroupsReadOnlyAccess','GroupsMinimumRequirements'),
('DefaultRole','GroupsReadOnlyAccess'),
('GroupsBasicAccess','GroupsReadOnlyAccess'),
('GroupsMinimumRequirements','GroupsSearch'),
('GroupsUpdateAccess','GroupsUpdate'),
('GroupsFullAccess','GroupsUpdateAccess'),
('GroupsReadOnlyAccess','GroupsView'),
('guest','GuestSiteFunctionsTask'),
('administrator','LeadRoutingTask'),
('MarketingAdminAccess','MarketingAdmin'),
('administrator','MarketingAdminAccess'),
('MarketingUpdateAccess','MarketingBasicAccess'),
('MarketingPrivateBasicAccess','MarketingBasicPrivate'),
('GuestSiteFunctionsTask','MarketingClick'),
('MarketingUpdateAccess','MarketingComplete'),
('MarketingUpdateAccess','MarketingGetX2ModelInput'),
('MarketingUpdatePrivate','MarketingComplete'),
('MarketingBasicAccess','MarketingCreate'),
('MarketingIndex','MarketingAjaxGetModelAutocomplete'),
('MarketingMinimumRequirements','MarketingMailIndividual'),
('MarketingPrivateBasicAccess','MarketingCreate'),
('MarketingBasicAccess','MarketingCreateFromTag'),
('MarketingPrivateBasicAccess','MarketingCreateFromTag'),
('MarketingDeletePrivate','MarketingDelete'),
('MarketingFullAccess','MarketingRemoveWebLeadFormCustomHtml'),
('MarketingFullAccess','MarketingSaveWebLeadFormCustomHtml'),
('MarketingFullAccess','MarketingDelete'),
('MarketingDeletePrivate','MarketingDeleteNote'),
('MarketingFullAccess','MarketingDeleteNote'),
('MarketingPrivateFullAccess','MarketingDeletePrivate'),
('MarketingAdminAccess','MarketingFullAccess'),
('MarketingMinimumRequirements','MarketingGetItems'),
('MarketingMinimumRequirements','MarketingIndex'),
('MarketingBasicAccess','MarketingLaunch'),
('MarketingBasicPrivate','MarketingLaunch'),
('MarketingPrivateReadOnlyAccess','MarketingMinimumRequirements'),
('MarketingReadOnlyAccess','MarketingMinimumRequirements'),
('DefaultRole','MarketingPrivateUpdateAccess'),
('MarketingPrivateUpdateAccess','MarketingPrivateBasicAccess'),
('MarketingPrivateBasicAccess','MarketingReadOnlyAccess'),
('MarketingPrivateFullAccess','MarketingPrivateUpdateAccess'),
('MarketingBasicAccess','MarketingReadOnlyAccess'),
('MarketingBasicAccess','MarketingGetCampaignChartData'),
('MarketingMinimumRequirements','MarketingSearch'),
('MarketingBasicAccess','MarketingToggle'),
('MarketingBasicPrivate','MarketingToggle'),
('MarketingUpdateAccess','MarketingUpdate'),
('MarketingUpdatePrivate','MarketingUpdate'),
('MarketingFullAccess','MarketingUpdateAccess'),
('MarketingPrivateUpdateAccess','MarketingUpdatePrivate'),
('MarketingReadOnlyAccess','MarketingView'),
('MarketingViewPrivate','MarketingView'),
('AuthenticatedSiteFunctionsTask','MediaRecursiveDriveFiles'),
('AuthenticatedSiteFunctionsTask','MediaRefreshDriveCache'),
('MarketingPrivateReadOnlyAccess','MarketingViewPrivate'),
('LeadRoutingTask','MarketingWebLeadForm'),
('MarketingAdminAccess','MarketingWebleadForm'),
/*('MarketingAdminAccess','MarketingAjaxDeleteWebForm'),*/
('MediaAdminAccess','MediaAdmin'),
('administrator','MediaAdminAccess'),
('MediaUpdateAccess','MediaBasicAccess'),
('MediaFullAccess','MediaDelete'),
('MediaFullAccess','MediaDeleteNote'),
('MediaReadOnlyAccess','MediaDownload'),
('MediaAdminAccess','MediaFullAccess'),
('MediaMinimumRequirements','MediaIndex'),
('MediaReadOnlyAccess','MediaMinimumRequirements'),
('MediaBasicAccess','MediaReadOnlyAccess'),
('MediaMinimumRequirements','MediaSearch'),
('AuthenticatedSiteFunctionsTask','MediaToggleUserMediaVisible'),
('MediaUpdateAccess','MediaUpdate'),
('MediaUpdateAccess','MediaGetX2ModelInput'),
('DefaultRole','MediaUpdateAccess'),
('MediaFullAccess','MediaUpdateAccess'),
('MediaBasicAccess','MediaUpload'),
('MediaBasicAccess','MediaCreate'),
('MediaReadOnlyAccess','MediaView'),
('MediaReadOnlyAccess','MediaQtip'),
('MediaIndex','MediaAjaxGetModelAutocomplete'),
('OpportunitiesUpdateAccess','OpportunitiesAddContact'),
('OpportunitiesUpdatePrivate','OpportunitiesAddContact'),
('OpportunitiesUpdateAccess','OpportunitiesAddUser'),
('OpportunitiesUpdatePrivate','OpportunitiesAddUser'),
('OpportunitiesAdminAccess','OpportunitiesAdmin'),
('administrator','OpportunitiesAdminAccess'),
('OpportunitiesPrivateUpdateAccess','OpportunitiesBasicAccess'),
('OpportunitiesUpdateAccess','OpportunitiesBasicAccess'),
('OpportunitiesBasicAccess','OpportunitiesCreate'),
('OpportunitiesDeletePrivate','OpportunitiesDelete'),
('OpportunitiesFullAccess','OpportunitiesDelete'),
('OpportunitiesDeletePrivate','OpportunitiesDeleteNote'),
('OpportunitiesFullAccess','OpportunitiesDeleteNote'),
('OpporunitiesPrivateFullAccess','OpportunitiesDeletePrivate'),
('OpportunitiesAdminAccess','OpportunitiesFullAccess'),
('GuestSiteFunctionsTask','OpportunitiesGetItems'),
('OpportunitiesMinimumRequirements','OpportunitiesGetTerms'),
('OpportunitiesMinimumRequirements','OpportunitiesIndex'),
('OpportunitiesIndex', 'OpportunitiesAjaxGetModelAutocomplete'),
('OpportunitiesPrivateReadOnlyAccess','OpportunitiesMinimumRequirements'),
('OpportunitiesReadOnlyAccess','OpportunitiesMinimumRequirements'),
('OpporunitiesPrivateFullAccess','OpportunitiesPrivateUpdateAccess'),
('OpportunitiesBasicAccess','OpportunitiesReadOnlyAccess'),
('OpportunitiesUpdateAccess','OpportunitiesRemoveContact'),
('OpportunitiesUpdatePrivate','OpportunitiesRemoveContact'),
('OpportunitiesUpdateAccess','OpportunitiesRemoveUser'),
('OpportunitiesUpdatePrivate','OpportunitiesRemoveUser'),
('OpportunitiesMinimumRequirements','OpportunitiesSearch'),
('OpportunitiesReadOnlyAccess','OpportunitiesShareOpportunity'),
('OpportunitiesViewPrivate','OpportunitiesShareOpportunity'),
('OpportunitiesUpdateAccess','OpportunitiesUpdate'),
('OpportunitiesUpdateAccess','OpportunitiesGetX2ModelInput'),
('OpportunitiesUpdatePrivate','OpportunitiesUpdate'),
('DefaultRole','OpportunitiesUpdateAccess'),
('OpportunitiesFullAccess','OpportunitiesUpdateAccess'),
('OpportunitiesPrivateUpdateAccess','OpportunitiesUpdatePrivate'),
('OpportunitiesReadOnlyAccess','OpportunitiesView'),
('OpportunitiesViewPrivate','OpportunitiesView'),
('OpportunitiesPrivateReadOnlyAccess','OpportunitiesViewPrivate'),
('ProductsAdminAccess','ProductsAdmin'),
('administrator','ProductsAdminAccess'),
('ProductsPrivateUpdateAccess','ProductsBasicAccess'),
('ProductsUpdateAccess','ProductsBasicAccess'),
('ProductsBasicAccess','ProductsCreate'),
('ProductsDeletePrivate','ProductsDelete'),
('ProductsFullAccess','ProductsDelete'),
('ProductsDeletePrivate','ProductsDeleteNote'),
('ProductsFullAccess','ProductsDeleteNote'),
('ProductsPrivateFullAccess','ProductsDeletePrivate'),
('ProductsAdminAccess','ProductsFullAccess'),
('ProductsMinimumRequirements','ProductsGetItems'),
('ProductsMinimumRequirements','ProductsIndex'),
('ProductsIndex', 'ProductsAjaxGetModelAutocomplete'),
('ProductsPrivateReadOnlyAccess','ProductsMinimumRequirements'),
('ProductsReadOnlyAccess','ProductsMinimumRequirements'),
('ProductsPrivateFullAccess','ProductsPrivateUpdateAccess'),
('ProductsBasicAccess','ProductsReadOnlyAccess'),
('ProductsMinimumRequirements','ProductsSearch'),
('ProductsUpdateAccess','ProductsUpdate'),
('ProductsUpdatePrivate','ProductsUpdate'),
('ProductsUpdateAccess','ProductsGetX2ModelInput'),
('GeneralAdminSettingsTask','CredentialsAdmin'),
('DefaultRole','CredentialsCreateUpdateOwn'),
('DefaultRole','CredentialsDeleteOwn'),
('DefaultRole','CredentialsSelectOwn'),
('DefaultRole','CredentialsSelectSystemwide'),
('CredentialsAdmin','CredentialsCreateUpdateSystemwide'),
('CredentialsAdmin','CredentialsDeleteSystemwide'),
('CredentialsAdmin','CredentialsSelectNonPrivate'),
('CredentialsAdmin','CredentialsSetDefaultSystemwide'),
('CredentialsCreateUpdateOwn','CredentialsCreateUpdate'),
('CredentialsCreateUpdateSystemwide','CredentialsCreateUpdate'),
('CredentialsDeleteOwn','CredentialsDelete'),
('CredentialsDeleteSystemwide','CredentialsDelete'),
('CredentialsSelectOwn','CredentialsSelect'),
('CredentialsSelectNonPrivate','CredentialsSelect'),
('CredentialsSelectSystemwide','CredentialsSelect'),
('CredentialsSelect','CredentialsSetDefaultOwn'),
('CredentialsSetDefaultOwn','CredentialsSetDefault'),
('CredentialsSetDefaultSystemwide','CredentialsSetDefault'),
('DefaultRole','ProductsUpdateAccess'),
('ProductsFullAccess','ProductsUpdateAccess'),
('ProductsPrivateUpdateAccess','ProductsUpdatePrivate'),
('ProductsReadOnlyAccess','ProductsView'),
('ProductsViewPrivate','ProductsView'),
('ProductsPrivateReadOnlyAccess','ProductsViewPrivate'),
('QuotesAdminAccess','QuotesAdmin'),
('administrator','QuotesAdminAccess'),
('QuotesPrivateUpdateAccess','QuotesBasicAccess'),
('QuotesUpdateAccess','QuotesBasicAccess'),
('QuotesBasicAccess','QuotesCreate'),
('QuotesDeletePrivate','QuotesDelete'),
('QuotesFullAccess','QuotesDelete'),
('QuotesDeletePrivate','QuotesDeleteNote'),
('QuotesFullAccess','QuotesDeleteNote'),
('QuotesPrivateFullAccess','QuotesDeletePrivate'),
('QuotesUpdateAccess','QuotesDeleteProduct'),
('QuotesUpdatePrivate','QuotesDeleteProduct'),
('QuotesAdminAccess','QuotesFullAccess'),
('GuestSiteFunctionsTask','QuotesGetItems'),
('QuotesMinimumRequirements','QuotesGetTerms'),
('QuotesMinimumRequirements','QuotesIndex'),
('QuotesIndex', 'QuotesAjaxGetModelAutocomplete'),
('QuotesPrivateReadOnlyAccess','QuotesMinimumRequirements'),
('QuotesReadOnlyAccess','QuotesMinimumRequirements'),
('QuotesReadOnlyAccess','QuotesPrint'),
('QuotesViewPrivate','QuotesPrint'),
('QuotesPrivateFullAccess','QuotesPrivateUpdateAccess'),
('QuotesBasicAccess','QuotesQuickCreate'),
('QuotesDeletePrivate','QuotesQuickDelete'),
('QuotesFullAccess','QuotesQuickDelete'),
('QuotesUpdateAccess','QuotesQuickUpdate'),
('QuotesUpdatePrivate','QuotesQuickUpdate'),
('QuotesBasicAccess','QuotesReadOnlyAccess'),
('QuotesUpdateAccess','QuotesRemoveUser'),
('QuotesUpdatePrivate','QuotesRemoveUser'),
('QuotesMinimumRequirements','QuotesSearch'),
('QuotesReadOnlyAccess','QuotesShareQuote'),
('QuotesViewPrivate','QuotesShareQuote'),
('QuotesUpdateAccess','QuotesUpdate'),
('QuotesUpdateAccess','QuotesGetX2ModelInput'),
('QuotesUpdatePrivate','QuotesUpdate'),
('DefaultRole','QuotesUpdateAccess'),
('QuotesFullAccess','QuotesUpdateAccess'),
('QuotesPrivateUpdateAccess','QuotesUpdatePrivate'),
('QuotesReadOnlyAccess','QuotesView'),
('QuotesViewPrivate','QuotesView'),
('QuotesReadOnlyAccess','QuotesViewInline'),
('QuotesViewPrivate','QuotesViewInline'),
('QuotesPrivateReadOnlyAccess','QuotesViewPrivate'),
('ServicesAdminAccess','ServicesAdmin'),
('administrator','ServicesAdminAccess'),
('ServicesPrivateUpdateAccess','ServicesBasicAccess'),
('ServicesUpdateAccess','ServicesBasicAccess'),
('ServicesBasicAccess','ServicesCreate'),
('ServicesDeletePrivate','ServicesDelete'),
('ServicesFullAccess','ServicesDelete'),
('ServicesFullAccess','ServicesDeleteNote'),
('ServicesPrivateFullAccess','ServicesDeleteNote'),
('ServicesPrivateFullAccess','ServicesDeletePrivate'),
('ServicesAdminAccess','ServicesFullAccess'),
('ServicesMinimumRequirements','ServicesGetItems'),
('ServicesMinimumRequirements','ServicesIndex'),
('ServicesIndex', 'ServicesAjaxGetModelAutocomplete'),
('ServicesPrivateReadOnlyAccess','ServicesMinimumRequirements'),
('ServicesReadOnlyAccess','ServicesMinimumRequirements'),
('ServicesPrivateFullAccess','ServicesPrivateUpdateAccess'),
('ServicesBasicAccess','ServicesReadOnlyAccess'),
('ServicesMinimumRequirements','ServicesSearch'),
('ServicesUpdateAccess','ServicesUpdate'),
('ServicesUpdateAccess','ServicesGetX2ModelInput'),
('ServicesUpdatePrivate','ServicesUpdate'),
('ServicesFullAccess','ServicesUpdateAccess'),
('DefaultRole','ServicesUpdateAccess'),
('ServicesPrivateUpdateAccess','ServicesUpdatePrivate'),
('ServicesReadOnlyAccess','ServicesView'),
('ServicesViewPrivate','ServicesView'),
('ServicesPrivateReadOnlyAccess','ServicesViewPrivate'),
('ServicesAdminAccess','ServicesCreateWebForm'),
('administrator','RoleAccessTask'),
('AuthenticatedSiteFunctionsTask','GuestSiteFunctionsTask'),
('GuestSiteFunctionsTask','SiteIndex'),
('GuestSiteFunctionsTask','SiteLogin'),
('AuthenticatedSiteFunctionsTask','SiteLogout'),
('AuthenticatedSiteFunctionsTask','SiteToggleVisibility'),
('AuthenticatedSiteFunctionsTask','SiteWhatsNew'),
('administrator','TranslationsTask'),
('AuthenticatedSiteFunctionsTask','UsersAddTopContact'),
('UsersMinimumRequirements','UsersAdmin'),
('administrator','UsersAdminAccess'),
('UsersUpdateAccess','UsersBasicAccess'),
('UsersBasicAccess','UsersCreate'),
('GuestSiteFunctionsTask','UsersCreateAccount'),
('UsersFullAccess','UsersDelete'),
('UsersFullAccess','UsersDeleteNote'),
('UsersAdminAccess','UsersFullAccess'),
('UsersMinimumRequirements','UsersIndex'),
('UsersIndex', 'UsersAjaxGetModelAutocomplete'),
('UsersAdminAccess','UsersInviteUsers'),
('UsersReadOnlyAccess','UsersMinimumRequirements'),
('UsersBasicAccess','UsersReadOnlyAccess'),
('AuthenticatedSiteFunctionsTask','UsersRemoveTopContact'),
('UsersMinimumRequirements','UsersSearch'),
('UsersUpdateAccess','UsersUpdate'),
('UsersFullAccess','UsersUpdateAccess'),
('UsersReadOnlyAccess','UsersView'),
('WorkflowAdminAccess','WorkflowAdmin'),
('administrator','WorkflowAdminAccess'),
('WorkflowUpdateAccess','WorkflowBasicAccess'),
('AuthenticatedSiteFunctionsTask','WorkflowCompleteStage'),
('WorkflowBasicAccess','WorkflowCreate'),
('WorkflowFullAccess','WorkflowDelete'),
('WorkflowFullAccess','WorkflowDeleteNote'),
('WorkflowAdminAccess','WorkflowFullAccess'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageMembers'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStages'),
('AuthenticatedSiteFunctionsTask','WorkflowGetWorkflow'),
('WorkflowMinimumRequirements','WorkflowIndex'),
('WorkflowIndex','WorkflowAjaxGetModelAutocomplete'),
('WorkflowReadOnlyAccess','WorkflowMinimumRequirements'),
('DefaultRole','WorkflowReadOnlyAccess'),
('WorkflowBasicAccess','WorkflowReadOnlyAccess'),
('AuthenticatedSiteFunctionsTask','WorkflowRevertStage'),
('WorkflowMinimumRequirements','WorkflowSearch'),
('AuthenticatedSiteFunctionsTask','WorkflowStartStage'),
('WorkflowUpdateAccess','WorkflowUpdate'),
('WorkflowFullAccess','WorkflowUpdateAccess'),
('AuthenticatedSiteFunctionsTask','WorkflowUpdateStageDetails'),
('WorkflowReadOnlyAccess','WorkflowView'),
('AuthenticatedSiteFunctionsTask','WorkflowViewStage'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageValue'),
('administrator','X2StudioTask'),
('AuthenticatedSiteFunctionsTask','WorkflowGetStageDetails'),
('admin','administrator'),
('authenticated','DefaultRole'),
('GeneralAdminSettingsTask','AdminCalculateTranslationRedundancy'),
('GeneralAdminSettingsTask','AdminFindMissingPermissions'),
('GeneralAdminSettingsTask','AdminGetWorkflowStages'),
('GeneralAdminSettingsTask','AdminGetRole'),
('GeneralAdminSettingsTask','AdminDeleteCriteria'),
('GeneralAdminSettingsTask','AdminDeleteRouting'),
('GeneralAdminSettingsTask','AdminGetAttributes'),
('GeneralAdminSettingsTask','AdminActivitySettings'),
('GeneralAdminSettingsTask','AdminSetServiceRouting'),
('GeneralAdminSettingsTask','AdminValidateField'),
('GeneralAdminSettingsTask','AdminRemoveField'),
('GeneralAdminSettingsTask','AdminGetFieldData'),
('AuthenticatedSiteFunctionsTask','AdminViewPage'),
('AuthenticatedSiteFunctionsTask','AdminGetRoutingType'),
('GuestSiteFunctionsTask','AdminGetRoutingType'),
('GeneralAdminSettingsTask','AdminRegisterModules'),
('GeneralAdminSettingsTask','AdminToggleModule'),
('GeneralAdminSettingsTask','AdminCreateFormLayout'),
('GeneralAdminSettingsTask','AdminDeleteFormLayout'),
('GeneralAdminSettingsTask','AdminGetDropdown'),
('GeneralAdminSettingsTask','AdminGetFieldType'),
('GeneralAdminSettingsTask','AdminDelete'),
('GeneralAdminSettingsTask','AdminInstallUpdate'),
('GeneralAdminSettingsTask','AdminCleanUp'),
('GeneralAdminSettingsTask','AdminViewLogs'),
('GeneralAdminSettingsTask','AdminAuthGraph'),
('GeneralAdminSettingsTask','AdminFlowDesigner'),
('GeneralAdminSettingsTask','AdminUserViewLog'),
('GeneralAdminSettingsTask','AdminClearViewHistory'),
('GeneralAdminSettingsTask','AdminCalculateMissingTranslations'),
('GeneralAdminSettingsTask','AdminConvertCustomModules'),
('ActionsReadOnlyAccess','ActionsViewEmail'),
('ActionsViewPrivate','ActionsViewEmail'),
('GuestSiteFunctionsTask','ActionsEmailOpened'),
('CalendarMinimumRequirements','CalendarList'),
('ContactsReadOnlyAccess','ContactsRevisions'),
('ContactsViewPrivate','ContactsRevisions'),
('ContactsUpdateAccess','ContactsSyncAccount'),
('ContactsUpdatePrivate','ContactsSyncAccount'),
('ContactsMinimumRequirements','ContactsGoogleMaps'),
('ContactsMinimumRequirements','ContactsSaveMap'),
('ContactsMinimumRequirements','ContactsSavedMaps'),
('ContactsMinimumRequirements','ContactsDeleteMap'),
('ContactsMinimumRequirements','ContactsUpdateLocation'),
('ContactsAdminAccess','ContactsCleanFailedLeads'),
('GuestSiteFunctionsTask','ContactsWeblead'),
('AuthenticatedSiteFunctionsTask','ContactsWeblead'),
('MarketingReadOnlyAccess','MarketingViewContent'),
('MarketingViewPrivate','MarketingViewContent'),
('GuestSiteFunctionsTask','WeblistWeblist'),
('AuthenticatedSiteFunctionsTask','WeblistWeblist'),
('AuthenticatedSiteFunctionsTask','MediaAjaxUpload'),
('QuotesMinimumRequirements','QuotesIndexInvoice'),
('QuotesUpdateAccess','QuotesConvertToInvoice'),
('QuotesUpdatePrivate','QuotesConvertToInvoice'),
('GuestSiteFunctionsTask','ServicesWebForm'),
('AuthenticatedSiteFunctionsTask','ServicesWebForm'),
('ServicesMinimumRequirements','ServicesStatusFilter'),
('UsersAdminAccess','UsersDeleteTemporary'),
('BugReportsMinimumRequirements','BugReportsIndex'),
('BugReportsIndex','BugReportsAjaxGetModelAutocomplete'),
('BugReportsMinimumRequirements','BugReportsGetItems'),
('BugReportsMinimumRequirements','BugReportsStatusFilter'),
('BugReportsMinimumRequirements','BugReportsDeleteNote'),
('BugReportsMinimumRequirements','BugReportsSearch'),
('BugReportsReadOnlyAccess','BugReportsView'),
('BugReportsReadOnlyAccess','BugReportsMinimumRequirements'),
('BugReportsBasicAccess','BugReportsCreate'),
('BugReportsBasicAccess','BugReportsReadOnlyAccess'),
('BugReportsUpdateAccess','BugReportsUpdate'),
('BugReportsUpdateAccess','BugReportsGetX2ModelInput'),
('BugReportsUpdateAccess','BugReportsBasicAccess'),
('BugReportsFullAccess','BugReportsDelete'),
('BugReportsFullAccess','BugReportsUpdateAccess'),
('BugReportsAdminAccess','BugReportsAdmin'),
('BugReportsAdminAccess','BugReportsFullAccess'),
('BugReportsViewPrivate','BugReportsView'),
('BugReportsUpdatePrivate','BugReportsUpdate'),
('BugReportsDeletePrivate','BugReportsDelete'),
('BugReportsPrivateReadOnlyAccess','BugReportsMinimumRequirements'),
('BugReportsPrivateReadOnlyAccess','BugReportsViewPrivate'),
('BugReportsPrivateUpdateAccess','BugReportsBasicAccess'),
('BugReportsPrivateUpdateAccess','BugReportsUpdatePrivate'),
('BugReportsPrivateFullAccess','BugReportsPrivateUpdateAccess'),
('BugReportsPrivateFullAccess','BugReportsDeletePrivate'),
('ReportsIndex','ReportsAjaxGetModelAutocomplete'),
('WeblistIndex','WeblistAjaxGetModelAutocomplete'),
('DefaultRole','BugReportsUpdateAccess'),
('administrator','BugReportsAdminAccess');
