<?php

/*****************************************************************************************
 * X2Engine Open Source Edition is a customer relationship management program developed by
 * X2Engine, Inc. Copyright (C) 2011-2014 X2Engine Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY X2ENGINE, X2ENGINE DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact X2Engine, Inc. P.O. Box 66752, Scotts Valley,
 * California 95067, USA. or at email address contact@x2engine.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * X2Engine" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by X2Engine".
 *****************************************************************************************/

Yii::import ('application.modules.contacts.models.*');
Yii::import ('application.components.*');
Yii::import ('application.components.x2flow.*');
Yii::import ('application.components.x2flow.triggers.*');
Yii::import ('application.components.permissions.*');

/**
 * @package application.tests.unit.components.x2flow.triggers
 */
class WebleadTriggerTest extends X2DbTestCase {

    public $fixtures = array (
        'x2flow' => array ('X2Flow', '_1'),
        'contacts' => array ('Contacts', '_2')
    );

    /**
     * Trigger config contains leadSource = 'Google' condition
     */
    public function testCheckWithNoTagsAndWithConditions () {
        $flows = X2FlowTestingAuxLib::getFlows ($this);
        $flow3 = $flows['flow3'];

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact1']),
            'modelClass' => 'Contacts',
        );
        $trigger = X2FlowItem::create ($flow3['trigger']);
        $retVal = $trigger->check ($params);

        // lead source condition succeeds
        $this->assertTrue ($retVal[0]);

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact2']),
            'modelClass' => 'Contacts',
        );
        $retVal = $trigger->check ($params);

        // lead source condition fails
        $this->assertFalse ($retVal[0]);
    }

    /**
     * Trigger config contains leadSource = 'Google' condition #successful tag condition
     */
    public function testCheckWithTagsAndWithConditions () {
        $flows = X2FlowTestingAuxLib::getFlows ($this);
        $flow4 = $flows['flow4'];

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact1']),
            'modelClass' => 'Contacts',
        );
        $trigger = X2FlowItem::create ($flow4['trigger']);
        $retVal = $trigger->check ($params);

        // lead source condition succeeds, tag condition fails  10
        $this->assertFalse ($retVal[0]);

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact2']),
            'modelClass' => 'Contacts',
        );
        $retVal = $trigger->check ($params);

        // lead source condition fails, tag condition fails  00
        $this->assertFalse ($retVal[0]);

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact1']),
            'modelClass' => 'Contacts',
            'tags' => '#successful'
        );
        $trigger = X2FlowItem::create ($flow4['trigger']);
        $retVal = $trigger->check ($params);

        // lead source condition succeeds, tag condition succeeds  11
        $this->assertTrue ($retVal[0]);

        $params = array (
            'model' => Contacts::Model ()->findByAttributes ($this->contacts['contact2']),
            'modelClass' => 'Contacts',
            'tags' => '#successful'
        );
        $retVal = $trigger->check ($params);

        // lead source condition fails, tag condition succeeds   01
        $this->assertFalse ($retVal[0]);
    }

}

?>
